/*
 * Decompiled with CFR 0.152.
 */
package com.visigenic.vbroker.activationImpl;

import com.visigenic.vbroker.Activation.FailedToExecute;
import com.visigenic.vbroker.Activation.State;
import com.visigenic.vbroker.activationImpl.ExecForwarderFactory;
import com.visigenic.vbroker.activationImpl.ExecObjectStatusWrapper;
import com.visigenic.vbroker.activationImpl.ObjectStatusWrapper;
import com.visigenic.vbroker.activationImpl.ObjectStatusWrapperImpl;
import com.visigenic.vbroker.activationImpl.SkelForwarder;
import com.visigenic.vbroker.extension.CreationImplDef;
import java.io.IOException;
import java.util.Vector;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.NO_RESPONSE;
import org.omg.CORBA.Object;

class ExecForwarder
extends SkelForwarder {
    private boolean _quoteStringsWithSpaces;

    ExecForwarder(CreationImplDef creationImplDef, ExecForwarderFactory execForwarderFactory, boolean bl, boolean bl2) {
        super(creationImplDef, execForwarderFactory, execForwarderFactory.boa(), bl);
        this._quoteStringsWithSpaces = bl2;
    }

    public Object getObject() {
        if (this.isSerialized()) {
            ExecForwarder execForwarder = this;
            synchronized (execForwarder) {
                Object object = this.getObjectHelper();
                java.lang.Object var3_3 = null;
                return object;
            }
        }
        return this.getObjectHelper();
    }

    public Object getObjectHelper() {
        ObjectStatusWrapper objectStatusWrapper;
        Object object = null;
        while ((object = this.currentlyActive()) != null && object._non_existent()) {
            if (this._verbose) {
                System.out.println("Forwarder: currently active object is null or non_existent");
            }
            if ((objectStatusWrapper = this.getStatus(0, object)) == null) continue;
            this.destroyForStatus(objectStatusWrapper);
            this._status_list.removeElement(objectStatusWrapper);
        }
        if (object == null) {
            objectStatusWrapper = (ExecObjectStatusWrapper)this.createObjectStatusWrapper(this._nextUID(), State.WAITING_FOR_ACTIVATION, null);
            this._status_list.addElement(objectStatusWrapper);
            ObjectStatusWrapper objectStatusWrapper2 = objectStatusWrapper;
            synchronized (objectStatusWrapper2) {
                String[] stringArray = this._command(this._impl, ((ObjectStatusWrapperImpl)objectStatusWrapper)._status.unique_id);
                String string = null;
                try {
                    ((ExecObjectStatusWrapper)objectStatusWrapper)._process = this._spawn(stringArray, this._env(this._impl, ((ObjectStatusWrapperImpl)objectStatusWrapper)._status.unique_id));
                    ((ExecForwarderFactory)this._factory).printerThread().AddCommand(this, (ExecObjectStatusWrapper)objectStatusWrapper, stringArray);
                }
                catch (FailedToExecute failedToExecute) {
                    string = "Failed to execute server [" + this._impl.path_name() + "]";
                    if (this._verbose) {
                        System.out.println(string);
                    }
                    throw new NO_RESPONSE(string);
                }
                try {
                    if (this._factory.timeout() == 0) {
                        objectStatusWrapper.wait();
                    } else {
                        objectStatusWrapper.wait(this._factory.timeout() * 1000);
                    }
                }
                catch (InterruptedException interruptedException) {}
                try {
                    if (((ExecObjectStatusWrapper)objectStatusWrapper)._process != null) {
                        int n = ((ExecObjectStatusWrapper)objectStatusWrapper)._process.exitValue();
                        string = "OAD::(" + stringArray[0] + ") exit=" + n;
                    }
                }
                catch (IllegalThreadStateException illegalThreadStateException) {}
                if (((ObjectStatusWrapperImpl)objectStatusWrapper)._status.activation_state == State.WAITING_FOR_ACTIVATION) {
                    this.destroyForStatus(objectStatusWrapper);
                }
                if (((ObjectStatusWrapperImpl)objectStatusWrapper)._status.activation_state != State.ACTIVE) {
                    if (string == null) {
                        string = "OAD::(" + stringArray[0] + ") did not activate object";
                    }
                    if (this._verbose) {
                        System.out.println(string);
                    }
                    this._status_list.removeElement(objectStatusWrapper);
                    throw new NO_RESPONSE(string);
                }
                object = ((ObjectStatusWrapperImpl)objectStatusWrapper)._status.objRef;
            }
        }
        if (this._verbose) {
            System.out.println("Forwarder: got object=[" + object + "]");
        }
        return object;
    }

    private String[] _command(CreationImplDef creationImplDef, int n) {
        java.lang.Object object;
        int n2;
        Vector<String> vector = new Vector<String>();
        boolean bl = creationImplDef.path_name().equals("vbj");
        if (bl) {
            String string;
            vector.insertElementAt(this.orb().getString("OAD_VBJ"), vector.size());
            vector.insertElementAt("-VBJprop", vector.size());
            vector.insertElementAt("OAoad_uid=" + n, vector.size());
            if (!this.orb().getBoolean("OAD_NOIOR")) {
                vector.insertElementAt("-VBJprop", vector.size());
                vector.insertElementAt("OAactivateIOR=" + this.orb().object_to_string(this._factory.oad()), vector.size());
            }
            n2 = 0;
            while (n2 < creationImplDef.env().length) {
                vector.insertElementAt(new String("-VBJprop"), vector.size());
                vector.insertElementAt(new String(creationImplDef.env()[n2]), vector.size());
                ++n2;
            }
            object = this.orb().getString("ORBagentPort");
            if (object != null) {
                vector.insertElementAt(new String("-VBJprop"), vector.size());
                vector.insertElementAt(new String("ORBagentPort=" + (String)object), vector.size());
            }
            if ((string = this.orb().getString("ORBagentAddr")) != null) {
                vector.insertElementAt(new String("-VBJprop"), vector.size());
                vector.insertElementAt(new String("ORBagentAddr=" + string), vector.size());
            }
        } else {
            vector.insertElementAt(creationImplDef.path_name(), vector.size());
        }
        n2 = 0;
        while (n2 < creationImplDef.args().length) {
            vector.insertElementAt(creationImplDef.args()[n2], vector.size());
            ++n2;
        }
        if (!bl && !this.isSerialized()) {
            vector.insertElementAt("-OAoad_uid", vector.size());
            vector.insertElementAt(Integer.toString(n), vector.size());
            vector.insertElementAt("-OAactivateIOR", vector.size());
            vector.insertElementAt(this.orb().object_to_string(this._factory.oad()), vector.size());
        }
        object = new String[vector.size()];
        vector.copyInto((java.lang.Object[])object);
        if (this._quoteStringsWithSpaces) {
            this.quoteStringsWithSpaces((String[])object);
        }
        return object;
    }

    private String[] _env(CreationImplDef creationImplDef, int n) {
        String string = this.orb().getString("ORBagentPort");
        String string2 = this.orb().getString("ORBagentAddr");
        String[] stringArray = new String[creationImplDef.env().length + 7];
        stringArray[0] = "PATH=" + this.orb().getString("OAD_PATH");
        stringArray[1] = "CLASSPATH=" + System.getProperty("java.class.path");
        stringArray[2] = string != null ? "OSAGENT_PORT=" + string : "DUMMY0=0";
        stringArray[3] = string2 != null ? "OSAGENT_ADDR=" + string2 : "DUMMY1=0";
        stringArray[4] = "ORBELINE=" + this.orb().getString("OAD_ORBELINE");
        stringArray[5] = "SystemRoot=" + this.orb().getString("OAD_SYSTEMROOT");
        stringArray[6] = "windir=" + this.orb().getString("OAD_WINDIR");
        int n2 = 0;
        while (n2 < creationImplDef.env().length) {
            stringArray[n2 + 7] = creationImplDef.env()[n2];
            ++n2;
        }
        if (this._verbose) {
            System.out.println("Environment for spawned executable:");
            int n3 = 0;
            while (n3 < stringArray.length) {
                System.out.println("\tenv[" + n3 + "]=" + stringArray[n3]);
                ++n3;
            }
        }
        return stringArray;
    }

    private Process _spawn(String[] stringArray, String[] stringArray2) throws FailedToExecute {
        try {
            if (this._verbose) {
                String string = new String(stringArray[0]);
                int n = 1;
                while (n < stringArray.length) {
                    string = String.valueOf(string) + " " + stringArray[n];
                    ++n;
                }
                System.out.println("OAD::(" + string + ")");
            }
            if (this.orb().getBoolean("OADnoEnv") && this._impl.env().length == 0) {
                return Runtime.getRuntime().exec(stringArray);
            }
            return Runtime.getRuntime().exec(stringArray, stringArray2);
        }
        catch (IOException iOException) {
            if (this._verbose) {
                iOException.printStackTrace();
            }
            throw new FailedToExecute();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new INTERNAL(arrayIndexOutOfBoundsException.toString());
        }
    }

    public void destroyForStatus(ObjectStatusWrapper objectStatusWrapper) {
        ExecObjectStatusWrapper execObjectStatusWrapper;
        if (!(objectStatusWrapper instanceof ExecObjectStatusWrapper)) {
            if (this._verbose) {
                System.out.println("Status wrapper of wrong specific type [" + objectStatusWrapper + "]");
            }
            return;
        }
        ExecObjectStatusWrapper execObjectStatusWrapper2 = execObjectStatusWrapper = (ExecObjectStatusWrapper)objectStatusWrapper;
        synchronized (execObjectStatusWrapper2) {
            if (execObjectStatusWrapper._process != null) {
                if (this._verbose) {
                    System.out.println("...destruction of a Process for [" + this._impl.repository_id() + ";" + this._impl.object_name() + "]");
                }
                ((ExecForwarderFactory)this._factory).printerThread().RemoveCommand(execObjectStatusWrapper._process);
                execObjectStatusWrapper._process.destroy();
                execObjectStatusWrapper._process = null;
            }
            if (execObjectStatusWrapper.status().activation_state == State.WAITING_FOR_ACTIVATION) {
                execObjectStatusWrapper.status().activation_state = State.INACTIVE;
                execObjectStatusWrapper.notify();
            }
            return;
        }
    }

    public ObjectStatusWrapper createObjectStatusWrapper(int n, State state, Object object) {
        return new ExecObjectStatusWrapper(n, state, object);
    }

    public ObjectStatusWrapper getStatus(int n, Object object) {
        if (this.isSerialized()) {
            return this._getStatusForWaiting();
        }
        if (n == 0) {
            return this._getStatusForObjRef(object);
        }
        return this._getStatusForUID(n);
    }

    boolean isSerialized() {
        return this.orb().getBoolean("VisiCpp2Compat");
    }

    private void quoteStringsWithSpaces(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].indexOf(32) >= 0) {
                System.out.println("Converting [" + stringArray[n] + "] -->");
                stringArray[n] = "\"" + stringArray[n] + "\"";
                System.out.println("--> [" + stringArray[n] + "]");
            }
            ++n;
        }
    }
}

